using System;
using System.Globalization;
using System.IO;
using System.Management;
using System.Net;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Security.Cryptography;
using System.Threading;
using System.Threading.Tasks;
using System.Timers;
using System.Windows.Forms;
using AutoUpdaterDotNET;
using Clicker;

namespace Kampane
{
	internal static class Program
	{
		public static System.Timers.Timer ticker;

		public static bool IsInit = false;

		public static string CurrentWeb = "";

		public static double TimeOfStart = new TimeSpan(DateTime.Now.Ticks).TotalSeconds;

		private static bool AutoUpdate = false;

		[DllImport("kernel32.dll", SetLastError = true)]
		[return: MarshalAs(UnmanagedType.Bool)]
		public static extern bool AllocConsole();

		public static void UnhandledHandler(object sender, UnhandledExceptionEventArgs arqs)
		{
			Logger.FileLoggingEnabled = true;
			Exception ex = (Exception)arqs.ExceptionObject;
			Console.BackgroundColor = ConsoleColor.Red;
			Logger.LogToFile("[**UNHANDLED EXCEPTION**] " + ex.Message + ex.StackTrace, ConsoleColor.Black, "");
		}

		[STAThread]
		private static void Main(string[] args)
		{
			AppDomain.CurrentDomain.UnhandledException += UnhandledHandler;
			if (args.Length != 0 && args[0] == "-showmeoutput")
			{
				AllocConsole();
				Logger.FileLoggingEnabled = true;
			}
			new Mutex(initiallyOwned: true, "{mamemailSPID}", out var flag);
			if (!flag)
			{
				MessageBox.Show("Pošťák již je spuštěn" + string.Join("-", args));
				return;
			}
			Perfmon.Initialize();
			ticker = new System.Timers.Timer();
			ticker.Elapsed += TickLogic;
			SetTimer(set: true, 5000);
			Logger.LogToFile("[TICKER READY]");
			ClickingLogic.Initialization();
			AutoUpdater.CheckForUpdateEvent += async delegate(UpdateInfoEventArgs args2)
			{
				if (args2.IsUpdateAvailable)
				{
					ticker.Stop();
					ClickingLogic.DoViews = false;
					if (ClickingLogic.browser != null)
					{
						ClickingLogic.browser.Dispose();
						await Task.FromResult(ClickingLogic.browser.IsDisposed);
					}
					if (ClickingLogic.browser_views != null)
					{
						ClickingLogic.browser_views.Dispose();
						await Task.FromResult(ClickingLogic.browser_views.IsDisposed);
					}
					if (DialogResult.Yes == MessageBox.Show("Nová verze pošťáka je k dispozici. Chcete tuto aktualizaci automaticky stáhnout a nainstalovat?", "Nová verze aplikace k dispozici", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1))
					{
						if (AutoUpdater.DownloadUpdate(args2))
						{
							Application.Exit();
						}
					}
					else
					{
						Application.Exit();
					}
				}
			};
			Logger.LogToFile("[AUTOUPDATE READY]");
			foreach (string obj in args)
			{
				if (obj.Contains("-noautoupdate"))
				{
					AutoUpdate = true;
				}
				if (obj.Contains("-noviews"))
				{
					ClickingLogic.DoViews = false;
				}
				if (obj.Contains("-log"))
				{
					Logger.FileLoggingEnabled = true;
				}
			}
			Logger.LogToFile("[ARGS PARSED]");
			ClickingLogic.PhaseMove += PhaseMove;
			Logger.LogToFile("[CLICKER READY]");
			Perfmon.LoadHigh += delegate
			{
				Logger.LogToFile("[VIEWS]", ConsoleColor.Red, "Disabling to reduce CPU load");
				ClickingLogic.DoViews = false;
			};
			Perfmon.LoadLow += delegate
			{
				ClickingLogic.DoViews = true;
			};
			Logger.LogToFile("[PERFMON READY]");
			LaunchUpdateThread();
			getUUID();
			using (HashAlgorithm hashAlgorithm = MD5.Create())
			{
				using FileStream fileStream = File.OpenRead(Assembly.GetEntryAssembly().Location);
				BitConverter.ToString(hashAlgorithm.ComputeHash(fileStream)).Replace("-", "").ToLower();
			}
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(defaultValue: false);
			Application.Run(new Form1());
		}

		public static void LaunchUpdateThread()
		{
			if (AutoUpdate)
			{
				return;
			}
			AutoUpdate = true;
			Thread thread = new Thread((ThreadStart)async delegate
			{
				Logger.LogToFile("[UPDATER]", ConsoleColor.Blue, "Thread started");
				while (AutoUpdate)
				{
					Logger.LogToFile("[UPDATER]", ConsoleColor.Blue, "Checking updates..");
					AutoUpdater.Start("https://mailfeed.cz/postak/update.php?pid=733");
					Logger.LogToFile("[UPDATER]", ConsoleColor.Blue, "Update checked");
					await Task.Delay(300000);
					AdsCache.RefreshCache();
				}
			});
			thread.IsBackground = true;
			thread.Priority = ThreadPriority.BelowNormal;
			thread.Start();
		}

		public static void SetTimer(bool set, int mils = 3000)
		{
			try
			{
				ticker.Interval = mils;
				ticker.Enabled = set;
				ticker.Stop();
				ticker.Start();
			}
			catch
			{
			}
		}

		public static string LoadString(string url)
		{
			using WebClient webClient = new WebClient();
			return webClient.DownloadString(url);
		}

		public static void PhaseMove(object sender, ClickingLogic.PhaseType type)
		{
			if (type == ClickingLogic.PhaseType.Phase1 || type == ClickingLogic.PhaseType.Phase2)
			{
				SetTimer(set: true, 30000);
			}
			else
			{
				SetTimer(set: true, 2000);
			}
		}

		public static async void TickLogic(object sender, EventArgs e)
		{
			Logger.LogToFile("[TICK]", ConsoleColor.DarkMagenta, "");
			SetTimer(set: true, (int)(AdsCache.TimerTimeout * 1000f));
			Perfmon.Tick();
			try
			{
				Logger.LogToFile("[LOGIC START]", ConsoleColor.DarkMagenta, "");
				CurrentWeb = LoadString("https://web-control.eu/pFt/FpZ.php?getSubject");
				Logger.LogToFile("[FPZ]", ConsoleColor.DarkCyan, CurrentWeb.Length.ToString());
				if (CurrentWeb.Length == 1)
				{
					Logger.LogToFile("[FPZ]", ConsoleColor.DarkCyan, "Idle command - sleep {0}s", AdsCache.TimerSkip);
					SetTimer(set: true, (int)AdsCache.TimerSkip * 1000);
				}
				else
				{
					ClickingLogic.IsRunning = false;
					await ClickingLogic.LoadWeb(CurrentWeb, ClickingLogic.BrowserLoaded, reset: true);
				}
			}
			catch (Exception ex)
			{
				Console.BackgroundColor = ConsoleColor.Red;
				Logger.LogToFile("[**ERROR**] " + ex.Message + ex.StackTrace, ConsoleColor.Black, "");
			}
		}

		public static long getUUID()
		{
			return long.Parse(((string)new ManagementObject("Win32_OperatingSystem=@")["SerialNumber"]).Split('-')[1], NumberStyles.HexNumber);
		}
	}
}
