using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using CefSharp;
using CefSharp.OffScreen;

namespace Clicker
{
	internal class ViewLogic
	{
		public static List<ChromiumWebBrowser> browsers = new List<ChromiumWebBrowser>();

		public static Random rand = new Random();

		public static int CurrentIndex = 0;

		public static DateTime updated;

		public static async void Initialize(bool cycle = false)
		{
			if (cycle)
			{
				for (int j = browsers.Count - 1; j < AdsCache.ViewInfo.Batch; j++)
				{
					browsers.Add(CreateNewBrowser());
				}
			}
			await Task.FromResult(AdsCache.views.Count > 0);
			for (int i = 0; i < AdsCache.ViewInfo.Batch; i++)
			{
				browsers.Add(CreateNewBrowser());
			}
		}

		public static async void BrowserLoaded(object sender, LoadingStateChangedEventArgs e)
		{
			ChromiumWebBrowser browser = (ChromiumWebBrowser)sender;
			if (!e.IsLoading)
			{
				if (!e.Browser.HasDocument)
				{
					await Task.FromResult(e.Browser.HasDocument);
				}
				browser.LoadingStateChanged -= BrowserLoaded;
				Logger.LogToFile("[VIEW]", ConsoleColor.DarkGray, "done: {0}", e.Browser.MainFrame.Url);
				await Task.Delay(rand.Next(1, 10) * 1000);
				browser.Load(IterateLinks());
				if (DateTime.Now.Subtract(updated).TotalSeconds > (double)AdsCache.ViewInfo.Cycler)
				{
					AdsCache.RefreshCache();
					Initialize(cycle: true);
				}
			}
		}

		public static ChromiumWebBrowser CreateNewBrowser()
		{
			ChromiumWebBrowser browser = new ChromiumWebBrowser(IterateLinks());
			Logger.LogToFile("[VIEW]", ConsoleColor.DarkGray, "new: {0}", browser.Address);
			browser.LoadingStateChanged += BrowserLoaded;
			return browser;
		}

		public static string IterateLinks()
		{
			if (AdsCache.views.Count == 0)
			{
				return "";
			}
			return AdsCache.views[CurrentIndex++ % AdsCache.views.Count];
		}
	}
}
