using System;
using System.Drawing;
using CefSharp;
using CefSharp.Enums;
using CefSharp.OffScreen;
using CefSharp.Structs;

namespace Clicker
{
	public class RenderHandler : IRenderHandler, IDisposable
	{
		private ChromiumWebBrowser browser;

		private CefSharp.Structs.Size popupSize;

		private CefSharp.Structs.Point popupPosition;

		public readonly object BitmapLock = new object();

		public bool PopupOpen { get; protected set; }

		public BitmapBuffer BitmapBuffer { get; private set; }

		public BitmapBuffer PopupBuffer { get; private set; }

		public CefSharp.Structs.Size PopupSize => popupSize;

		public CefSharp.Structs.Point PopupPosition => popupPosition;

		public RenderHandler(ChromiumWebBrowser browser)
		{
			this.browser = browser;
			popupPosition = default(CefSharp.Structs.Point);
			popupSize = default(CefSharp.Structs.Size);
			BitmapBuffer = new BitmapBuffer(BitmapLock);
			PopupBuffer = new BitmapBuffer(BitmapLock);
		}

		public void Dispose()
		{
			browser = null;
			BitmapBuffer = null;
			PopupBuffer = null;
		}

		public virtual ScreenInfo? GetScreenInfo()
		{
			ScreenInfo value = default(ScreenInfo);
			value.DeviceScaleFactor = 1f;
			return value;
		}

		public virtual Rect GetViewRect()
		{
			System.Drawing.Size size = browser.Size;
			return new Rect(0, 0, size.Width, size.Height);
		}

		public virtual bool GetScreenPoint(int viewX, int viewY, out int screenX, out int screenY)
		{
			screenX = viewX;
			screenY = viewY;
			return false;
		}

		public virtual void OnAcceleratedPaint(PaintElementType type, Rect dirtyRect, IntPtr sharedHandle)
		{
		}

		public virtual void OnPaint(PaintElementType type, Rect dirtyRect, IntPtr buffer, int width, int height)
		{
		}

		public virtual void OnCursorChange(IntPtr cursor, CursorType type, CursorInfo customCursorInfo)
		{
		}

		public virtual bool StartDragging(IDragData dragData, DragOperationsMask mask, int x, int y)
		{
			return false;
		}

		public virtual void UpdateDragCursor(DragOperationsMask operation)
		{
		}

		public virtual void OnPopupShow(bool show)
		{
			PopupOpen = show;
		}

		public virtual void OnPopupSize(Rect rect)
		{
			popupPosition = new CefSharp.Structs.Point(rect.X, rect.Y);
			popupSize = new CefSharp.Structs.Size(rect.Width, rect.Height);
		}

		public virtual void OnImeCompositionRangeChanged(Range selectedRange, Rect[] characterBounds)
		{
		}

		public virtual void OnVirtualKeyboardRequested(IBrowser browser, TextInputMode inputMode)
		{
		}

		public void RefreshBitmapBuffer()
		{
			BitmapBuffer = null;
			BitmapBuffer = new BitmapBuffer(BitmapLock);
		}
	}
}
