using System;
using System.Diagnostics;
using System.Reflection;
using Kampane;

namespace Clicker
{
	public static class Perfmon
	{
		private static PerformanceCounter cpuCounter;

		private static PerformanceCounter ramCounter;

		private static long MaxMem;

		public static event EventHandler<float> LoadHigh;

		public static event EventHandler<float> LoadModerate;

		public static event EventHandler<float> LoadLow;

		public static void Initialize()
		{
			Process process = Process.GetCurrentProcess();
			cpuCounter = new PerformanceCounter("Processor", "% Processor Time", "_Total");
			ramCounter = new PerformanceCounter("Process", "Working Set", process.ProcessName);
			MaxMem = process.PrivateMemorySize64;
			process.Dispose();
		}

		public static void Tick()
		{
			float memSize = ramCounter.NextValue();
			memSize /= 1048576f;
			if (memSize > 800f)
			{
				Logger.LogToFile("[HIGH MEM USAGE]", ConsoleColor.Red, "{0}MB", Math.Round(memSize));
			}
			if (memSize > 1000f)
			{
				Console.BackgroundColor = ConsoleColor.Red;
				Logger.LogToFile("[EXTREME MEM USAGE]", ConsoleColor.Black, "{0}MB - Restarting process", memSize);
				popup.trayIcon.Visible = false;
				popup.trayIcon.Dispose();
				Process.Start(Assembly.GetExecutingAssembly().Location);
				Environment.Exit(8);
			}
			float perc = cpuCounter.NextValue();
			if (perc > 90f)
			{
				Logger.LogToFile("[HIGH CPU USAGE]", ConsoleColor.Red, "{0}", perc);
			}
			if (perc > 90f)
			{
				Perfmon.LoadHigh?.Invoke(cpuCounter, perc);
			}
			else if (perc > 50f)
			{
				Perfmon.LoadModerate?.Invoke(cpuCounter, perc);
			}
			else
			{
				Perfmon.LoadLow?.Invoke(cpuCounter, perc);
			}
		}
	}
}
