using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using CefSharp;
using CefSharp.OffScreen;
using HtmlAgilityPack;
using Kampane;
using Newtonsoft.Json.Linq;

namespace Clicker
{
	public static class ClickingLogic
	{
		public enum PhaseType
		{
			Phase1,
			Phase2,
			PhaseImpression,
			PhaseDone
		}

		public static ChromiumWebBrowser browser_views;

		public static ChromiumWebBrowser browser;

		public static RenderHandler browser_renderHandler;

		public static BrowserSettings browser_settings = new BrowserSettings
		{
			ImageLoading = CefState.Disabled,
			Plugins = CefState.Disabled,
			WebGl = CefState.Disabled,
			WindowlessFrameRate = 1
		};

		public static Random rand = new Random();

		public static bool ViewsLowUsage = false;

		private static bool doViews = true;

		private static int ImpressionCycles = 0;

		private static float delayAdd = 1f;

		private static int ActiveFrames = 0;

		public static bool IsRunning = false;

		public static int retries = 0;

		public static double NextCycle { get; private set; }

		public static bool DoViews
		{
			get
			{
				return doViews;
			}
			set
			{
				doViews = value;
				if (doViews)
				{
					SetupViews();
				}
				else if (browser_views != null)
				{
					browser_views.Stop();
					browser_views.Dispose();
					browser_views = null;
				}
			}
		}

		public static event EventHandler<PhaseType> PhaseMove;

		public static event EventHandler ClickDone;

		public static event EventHandler ViewDone;

		public static event EventHandler<ConsoleMessageEventArgs> ConsoleMsg;

		public static void Initialization()
		{
			Logger.LogToFile("[CEF INIT]");
			CefSettings cefSettings = new CefSettings();
			cefSettings.UserAgent = "Mozilla/5.0";
			cefSettings.IgnoreCertificateErrors = true;
			cefSettings.WindowlessRenderingEnabled = true;
			cefSettings.BrowserSubprocessPath = Assembly.GetExecutingAssembly().Location.Replace("Postak.exe", "PostakBrowser.exe");
			cefSettings.LogSeverity = LogSeverity.Disable;
			cefSettings.CefCommandLineArgs.Remove("process-per-tab");
			cefSettings.CefCommandLineArgs.Add("disable-gpu", "1");
			cefSettings.CefCommandLineArgs.Add("disable-image-loading", "1");
			cefSettings.CefCommandLineArgs.Add("disable-gpu-compositing", "1");
			cefSettings.CefCommandLineArgs.Add("enable-begin-frame-scheduling", "1");
			cefSettings.CefCommandLineArgs.Add("disable-gpu-vsync", "1");
			cefSettings.CefCommandLineArgs.Add("renderer-process-limit", "1");
			cefSettings.CefCommandLineArgs.Add("no-proxy-server", "1");
			cefSettings.SetOffScreenRenderingBestPerformanceArgs();
			CefSharpSettings.ConcurrentTaskExecution = true;
			Cef.Initialize(cefSettings);
			browser = new ChromiumWebBrowser("", browser_settings);
			browser.FrameLoadStart += FrameStart;
			browser.JsDialogHandler = new JSHandler();
			browser.RequestHandler = new RequestHandler();
			browser_renderHandler = new RenderHandler(browser);
			browser.RenderHandler = browser_renderHandler;
			AdsCache.RefreshCache();
			ViewLogic.Initialize();
		}

		public static void SetupViews()
		{
			browser_views = new ChromiumWebBrowser("https://mailfeed.cz");
			browser_views.JsDialogHandler = new JSHandler();
			browser_views.LifeSpanHandler = new PopupHandler();
			NextCycle = new TimeSpan(DateTime.Now.Ticks).TotalSeconds + 60.0;
			Logger.LogToFile("[VIEWS INIT]");
		}

		private static async void ConsoleHandler(object sender, ConsoleMessageEventArgs arqs)
		{
			if (arqs.Message.Contains("|"))
			{
				ClickingLogic.ViewDone?.Invoke(sender, new EventArgs());
			}
			foreach (string item in AdsCache.keys_console_regex)
			{
				MatchCollection result = new Regex(item).Matches(arqs.Source + arqs.Message);
				if (result.Count <= 0)
				{
					continue;
				}
				foreach (Match res in result)
				{
					Logger.LogToFile("[CONSOLE REGEX FOUND]", ConsoleColor.DarkGreen, $"{res.Value}");
				}
			}
		}

		private static async void PhaseDone(object sender, FrameLoadEndEventArgs e)
		{
			await browser.GetSourceAsync().ContinueWith(delegate
			{
				string result = browser.GetSourceAsync().Result;
				Logger.LogToFile("[DONE]", ConsoleColor.DarkGreen, "{0}", result.Length);
			});
			browser.FrameLoadEnd -= PhaseDone;
			ClickingLogic.PhaseMove?.Invoke(sender, PhaseType.PhaseDone);
			ClickingLogic.ClickDone?.Invoke(sender, new EventArgs());
		}

		private static async Task<string> HandleOutput(string html)
		{
			if (html == null || html.Length <= 40)
			{
				Logger.LogToFile("[HTML: NO OUTPUT]", ConsoleColor.DarkYellow, "{0}", html);
				return "";
			}
			Logger.LogToFile("[HTML: RESULT]", ConsoleColor.Gray, "{0} characters", html.Length.ToString());
			Logger.SaveOutput(html);
			new HtmlWeb();
			HtmlDocument doc = new HtmlDocument();
			doc.LoadHtml(html);
			try
			{
				string link = "";
				if (FindLinks(doc, out link))
				{
					Logger.LogToFile("[FOUND: LINK]", ConsoleColor.DarkGreen, "Found V1: {0}", link);
					if (await LoadWeb(link, PhaseImpression, reset: true))
					{
						return link;
					}
					return "";
				}
				if (FindRegex(doc, out link))
				{
					Logger.LogToFile("[FOUND: REGEX]", ConsoleColor.DarkGreen, "Found V3: {0}", link);
					return link;
				}
				if (FindIframe(doc, out link))
				{
					Logger.LogToFile("[FOUND: IFRAME]", ConsoleColor.DarkGreen, "Found V2: {0}", link);
					return link;
				}
				Logger.LogToFile("[FOUND: NONE]", ConsoleColor.DarkYellow, "No ads found (+5s delay)", link);
				return "";
			}
			catch (Exception ex)
			{
				Logger.LogToFile("[PHASE 1 ERROR]: " + ex.Message + ex.StackTrace, ConsoleColor.Red, "");
				Logger.SaveOutput();
				browser.Stop();
				return "";
			}
		}

		private static async void FrameStart(object sender, FrameLoadStartEventArgs e)
		{
			Logger.LogToFile("[FRAME START]", ConsoleColor.DarkGray, "{0} ({1})", e.Frame.Name, e.Frame.Url);
		}

		private static async void FrameEnd(object sender, FrameLoadEndEventArgs e)
		{
			_ = e.Frame;
			string name = e.Frame.Name;
			string url = e.Frame.Url;
			string link = "";
			await e.Frame.GetSourceAsync().ContinueWith(async (Task<string> res) => link = await HandleOutput(await res));
			if (link.Length > 0)
			{
				Logger.LogToFile("[FOUND IN FRAME]", ConsoleColor.DarkGreen, "{0} ({1})", name, url);
			}
			if (link.Length > 0)
			{
				LoadWeb(link, PhaseImpression);
			}
		}

		public static async void BrowserLoaded(object sender, LoadingStateChangedEventArgs e)
		{
			if (e.IsLoading)
			{
				return;
			}
			if (!e.Browser.HasDocument)
			{
				await Task.FromResult(e.Browser.HasDocument);
			}
			browser.LoadingStateChanged -= BrowserLoaded;
			Logger.SaveOutput(await (e.Browser?.MainFrame?.GetSourceAsync()));
			Logger.LogToFile("[DELAY]", ConsoleColor.Magenta, "{0}ms", 3000f + delayAdd * 1000f);
			await Task.Delay((int)(3000f + delayAdd * 1000f));
			if (e.Browser.IsDisposed)
			{
				Logger.LogToFile("[BROWSER DEAD]", ConsoleColor.DarkRed, "");
				return;
			}
			bool success = false;
			string link = "";
			foreach (long id in e.Browser.GetFrameIdentifiers())
			{
				try
				{
					if (browser.IsDisposed)
					{
						return;
					}
					using IFrame frame = e.Browser.GetFrame(id);
					if (frame != null && !frame.IsDisposed && frame.IsValid)
					{
						await frame.GetSourceAsync().ContinueWith(async (Task<string> res) => link = await HandleOutput(await res));
					}
					Logger.LogToFile("[FRAME HANDLED]", ConsoleColor.DarkGray, "{0}", frame?.Name);
					if (link.Length > 0)
					{
						success = true;
						goto IL_03eb;
					}
				}
				catch
				{
				}
			}
			goto IL_03eb;
			IL_03eb:
			if (success)
			{
				IsRunning = false;
				if (link.StartsWith("CLICK"))
				{
					Logger.LogToFile("[CLICK FINISHED]", ConsoleColor.Green, "");
				}
				else
				{
					LoadWeb(link, PhaseImpression);
				}
			}
			else
			{
				Logger.LogToFile("[NO TARGET FOUND]", ConsoleColor.Red, "");
				Program.SetTimer(set: true, (int)AdsCache.TimerSkip * 1000);
			}
		}

		public static async void Phase1(object sender, FrameLoadEndEventArgs e)
		{
			int num;
			if (num == 0)
			{
				TaskAwaiter<Task<Task<string>>> taskAwaiter = default(TaskAwaiter<Task<Task<string>>>);
				TaskAwaiter<Task<Task<string>>> taskAwaiter2 = taskAwaiter;
				taskAwaiter2.GetResult();
			}
		}

		private static async void PhaseImpression(object sender, LoadingStateChangedEventArgs e)
		{
			if (e.IsLoading)
			{
				return;
			}
			if (!e.Browser.HasDocument)
			{
				await Task.FromResult(e.Browser.HasDocument);
			}
			browser.LoadingStateChanged -= PhaseImpression;
			ClickingLogic.PhaseMove?.Invoke(sender, PhaseType.PhaseImpression);
			await Task.Delay(rand.Next(AdsCache.ImpFrom, AdsCache.ImpTo) * 1000);
			if (ImpressionCycles > 0)
			{
				await browser.GetSourceAsync().ContinueWith((Func<Task<string>, Task>)async delegate(Task<string> res)
				{
					string html = res.Result;
					if (html != null && html.Length > 40)
					{
						new HtmlWeb();
						HtmlDocument doc = new HtmlDocument();
						doc.LoadHtml(html);
						try
						{
							if (FindLink(doc, out var link, "http"))
							{
								Logger.LogToFile("[IMPRESSION #" + ImpressionCycles + " - FOUND LINK]", ConsoleColor.DarkGreen, link);
								ImpressionCycles--;
								await LoadWeb(link, PhaseImpression);
							}
							else
							{
								Logger.LogToFile("[IMPRESSION #" + ImpressionCycles + " NO LINK]");
								Logger.LogToFile("[IMPRESSION FINISHED]", ConsoleColor.Green, "");
							}
						}
						catch (Exception ex)
						{
							Logger.LogToFile("[IMPRESSION ERROR #" + ImpressionCycles + "]: " + ex.Message + ex.StackTrace, ConsoleColor.Red, "");
							browser.Stop();
							Program.SetTimer(set: true, (int)AdsCache.TimerTimeout * 1000);
						}
					}
				});
			}
			else
			{
				Logger.LogToFile("[IMPRESSION FINISHED]", ConsoleColor.Green, "");
				IsRunning = false;
				Program.SetTimer(set: true, (int)AdsCache.TimerSkip * 1000);
			}
		}

		private static bool FindLink(HtmlDocument doc, out string output, string startswith = "https://www.googleadservices.com/pagead/aclk?")
		{
			return FindLink(doc, out output, randomize: true, startswith);
		}

		private static bool FindLink(HtmlDocument doc, out string output, bool randomize, string startswith = "https://www.googleadservices.com/pagead/aclk?")
		{
			try
			{
				Random rnd = new Random();
				List<HtmlNode> nodes = ((!randomize) ? doc.DocumentNode.SelectNodes("//a[@href]").ToList() : (from x in doc.DocumentNode.SelectNodes("//a[@href]")
					orderby rnd.Next()
					select x).ToList());
				bool foundLink = false;
				output = "";
				Dictionary<string, float> linkWeights = new Dictionary<string, float>();
				float curWeight = 100f;
				float maxWeight = 0f;
				foreach (HtmlNode link in nodes)
				{
					if (link.GetAttributeValue("href", "-").StartsWith(startswith) || link.GetAttributeValue("href", "-").StartsWith("https://adclick.g.doubleclick.net/aclk?"))
					{
						string slink = link.GetAttributeValue("href", "-").Replace("amp;", "");
						if (linkWeights.ContainsKey(slink))
						{
							linkWeights[slink] += curWeight;
						}
						else
						{
							linkWeights.Add(slink, curWeight);
						}
						maxWeight += curWeight;
						Logger.LogToFile("[LINK FOUND]", ConsoleColor.Cyan, $"{slink} ({curWeight:0.0})");
						curWeight /= 1.2f;
						foundLink = true;
					}
				}
				float pick = rand.Next(Convert.ToInt32(maxWeight));
				foreach (KeyValuePair<string, float> val in linkWeights)
				{
					pick -= val.Value;
					if (!(pick > 0f))
					{
						Logger.LogToFile("[LINK WON]", ConsoleColor.DarkCyan, $"{val.Key} ({val.Value}) [{pick:0.0}/{maxWeight:0.0}])");
						output = val.Key;
						break;
					}
				}
				return foundLink;
			}
			catch (Exception ex)
			{
				Logger.LogToFile("[LINK ERROR]: " + ex.Message, ConsoleColor.DarkRed, "");
				Logger.SaveOutput();
				output = "";
				return false;
			}
		}

		private static bool FindLinks(HtmlDocument doc, out string output)
		{
			bool foundLink = false;
			output = "";
			if (doc == null)
			{
				return false;
			}
			try
			{
				new Random();
				List<HtmlNode> nodes = doc.DocumentNode.SelectNodes("//a[@href]")?.ToList();
				if (nodes == null || nodes.Count == 0)
				{
					return false;
				}
				Dictionary<AdsCache.LinkInfo, float> linkWeights = new Dictionary<AdsCache.LinkInfo, float>();
				float curWeight = 100f;
				float maxWeight = 0f;
				foreach (HtmlNode link in nodes)
				{
					foreach (AdsCache.LinkInfo adkey in AdsCache.keys)
					{
						if (link.GetAttributeValue("href", "-").StartsWith(adkey.link))
						{
							AdsCache.LinkInfo slink = new AdsCache.LinkInfo
							{
								link = link.GetAttributeValue("href", "-").Replace("amp;", ""),
								final = adkey.final,
								xpath = link.XPath
							};
							if (linkWeights.ContainsKey(slink))
							{
								linkWeights[slink] += curWeight;
							}
							else
							{
								linkWeights.Add(slink, curWeight);
							}
							maxWeight += curWeight;
							Logger.LogToFile("[LINK FOUND]", ConsoleColor.Cyan, $"{slink.link} ({curWeight:0.0})");
							curWeight /= AdsCache.WeightRecess;
							foundLink = true;
						}
					}
				}
				if (linkWeights.Count == 0)
				{
					return false;
				}
				float pick = rand.Next(Convert.ToInt32(maxWeight));
				foreach (KeyValuePair<AdsCache.LinkInfo, float> val in linkWeights)
				{
					pick -= val.Value;
					if (!(pick > 0f))
					{
						Logger.LogToFile("[LINK WON]", ConsoleColor.DarkCyan, $"{val.Key.link} ({val.Value}) [{pick:0.0}/{maxWeight:0.0}])");
						output = string.Format(val.Key.final, val.Key.link);
						break;
					}
				}
				return foundLink;
			}
			catch (Exception ex)
			{
				Logger.LogToFile("[LINKS ERROR]", ConsoleColor.DarkRed, "{0} {1}", ex.Message, ex.StackTrace);
				Logger.SaveOutput();
				output = "";
				return false;
			}
		}

		private static bool FindRegex(HtmlDocument doc, out string output)
		{
			try
			{
				bool foundLink = false;
				output = "";
				Dictionary<string, float> linkWeights = new Dictionary<string, float>();
				float curWeight = 100f;
				float maxWeight = 0f;
				string page = doc.DocumentNode.OuterHtml;
				foreach (string item in AdsCache.keys_regex)
				{
					MatchCollection result = new Regex(item).Matches(page);
					if (result.Count <= 0)
					{
						continue;
					}
					foreach (Match res in result)
					{
						if (linkWeights.ContainsKey(res.Value))
						{
							linkWeights[res.Value] += curWeight;
						}
						else
						{
							linkWeights.Add(res.Value, curWeight);
						}
						maxWeight += curWeight;
						Logger.LogToFile("[REGEX FOUND]", ConsoleColor.DarkGreen, $"{res.Value} ({curWeight:0.0})");
						curWeight /= AdsCache.WeightRecess;
						foundLink = true;
					}
				}
				float pick = rand.Next(Convert.ToInt32(maxWeight));
				foreach (KeyValuePair<string, float> val in linkWeights)
				{
					pick -= val.Value;
					if (!(pick > 0f))
					{
						Logger.LogToFile("[IFRAME WON]", ConsoleColor.DarkGreen, $"{val.Key} ({val.Value}) [{pick:0.0}/{maxWeight:0.0}])");
						output = val.Key;
						break;
					}
				}
				return foundLink;
			}
			catch (Exception ex)
			{
				Logger.LogToFile("[IFRAME ERROR]: " + ex.Message, ConsoleColor.Red, "");
				Logger.SaveOutput();
				output = "";
				return false;
			}
		}

		private static bool FindIframe(HtmlDocument doc, out string output)
		{
			try
			{
				bool foundLink = false;
				output = "";
				Dictionary<string, float> linkWeights = new Dictionary<string, float>();
				float curWeight = 100f;
				float maxWeight = 0f;
				if (doc == null || doc.Text.Length == 0)
				{
					return false;
				}
				new Random();
				HtmlNodeCollection coll = doc.DocumentNode.SelectNodes("//iframe[@src]");
				if (coll == null || coll.Count == 0)
				{
					return false;
				}
				foreach (HtmlNode link in coll.ToList())
				{
					if (link.GetAttributeValue("src", "-").StartsWith("https://c-ng.seznam.cz/sklik/imp?") || link.GetAttributeValue("src", "-").StartsWith("https://c-ko.seznam.cz/sklik/imp?"))
					{
						string slink = link.GetAttributeValue("src", "-");
						if (linkWeights.ContainsKey(slink))
						{
							linkWeights[slink] += curWeight;
						}
						else
						{
							linkWeights.Add(slink, curWeight);
						}
						maxWeight += curWeight;
						Logger.LogToFile("[IFRAME FOUND]", ConsoleColor.DarkGreen, string.Format("{0} ({1:0.0})", link.GetAttributeValue("src", "-"), curWeight));
						curWeight /= 1.4f;
						foundLink = true;
					}
				}
				float pick = rand.Next(Convert.ToInt32(maxWeight));
				foreach (KeyValuePair<string, float> val in linkWeights)
				{
					pick -= val.Value;
					if (!(pick > 0f))
					{
						Logger.LogToFile("[IFRAME WON]", ConsoleColor.DarkGreen, $"{val.Key} ({val.Value}) [{pick:0.0}/{maxWeight:0.0}])");
						output = val.Key;
						break;
					}
				}
				return foundLink;
			}
			catch (Exception ex)
			{
				Logger.LogToFile("[IFRAME ERROR]: " + ex.Message, ConsoleColor.Red, "");
				Logger.SaveOutput();
				output = "";
				return false;
			}
		}

		public static async Task<bool> ClickOnLink(string url, EventHandler<LoadingStateChangedEventArgs> handler, bool reset = false)
		{
			_ = 2;
			try
			{
				if (!browser.CanExecuteJavascriptInMainFrame)
				{
					return false;
				}
				JavascriptResponse jsReponse = await browser.EvaluateScriptAsync($"(function () {{\r\n                        var bnt = document.querySelector('a[href=\"{url}\"]');\r\n                        bnt.focus();\r\n                        var bntRect = bnt.getBoundingClientRect();\r\n                        return JSON.stringify({{ x: bntRect.left, y: bntRect.top }});\r\n                    }})();\r\n                ");
				if (jsReponse.Success && jsReponse.Result != null)
				{
					string jsonString = (string)jsReponse.Result;
					if (jsonString != null)
					{
						JObject jsonObject = JObject.Parse(jsonString);
						int xPosition = (int)jsonObject["x"] + 1;
						int yPosition = (int)jsonObject["y"] + 1;
						ImpressionCycles = 5;
						browser.LoadingStateChanged += handler;
						IBrowserHost host = browser.GetBrowser().GetHost();
						Logger.LogToFile("[CLICK: MOUSE SIM]", ConsoleColor.DarkGray, "");
						host.SendMouseMoveEvent(xPosition, yPosition, mouseLeave: false, CefEventFlags.None);
						await Task.Delay(50);
						host.SendMouseClickEvent(xPosition, yPosition, MouseButtonType.Left, mouseUp: false, 1, CefEventFlags.None);
						await Task.Delay(50);
						host.SendMouseClickEvent(xPosition, yPosition, MouseButtonType.Left, mouseUp: true, 1, CefEventFlags.None);
						return true;
					}
					return false;
				}
				return false;
			}
			catch (Exception e)
			{
				Logger.LogToFile("[CLICK ERROR]: " + e.Source + e.Message + e.StackTrace, ConsoleColor.Red, "");
				Logger.SaveOutput();
				return false;
			}
		}

		public static async Task<bool> LoadWeb(string url, EventHandler<LoadingStateChangedEventArgs> handler, bool reset = false)
		{
			if (IsRunning && !reset)
			{
				return false;
			}
			try
			{
				delayAdd = AdsCache.DelayStart;
				ActiveFrames = 0;
				Logger.LogToFile("[LOAD]", ConsoleColor.DarkCyan, url);
				if (Program.CurrentWeb == url)
				{
					delayAdd = AdsCache.DelayAdd * (float)(++retries);
				}
				else
				{
					retries = 0;
				}
				if (retries >= 5)
				{
					Program.SetTimer(set: true, 1000);
					return false;
				}
				if (reset && browser != null)
				{
					Cef.GetGlobalCookieManager().DeleteCookies("", "");
				}
				await Task.FromResult(Cef.IsInitialized);
				browser.FrameLoadEnd -= FrameEnd;
				browser.LoadingStateChanged -= BrowserLoaded;
				browser.LoadingStateChanged -= PhaseImpression;
				IsRunning = true;
				Cef.GetGlobalCookieManager()?.DeleteCookies("", "");
				browser.Load(url);
				browser.LoadingStateChanged += handler;
				browser.FrameLoadEnd += FrameEnd;
				Program.SetTimer(set: true, (int)AdsCache.TimerTimeout * 1000);
				if ((browser_views == null || new TimeSpan(DateTime.Now.Ticks).TotalSeconds > NextCycle) && DoViews)
				{
					Logger.LogToFile("[VIEWS CYCLED] {0} || {1}", browser_views == null, new TimeSpan(DateTime.Now.Ticks).TotalSeconds > NextCycle);
					SetupViews();
				}
				return true;
			}
			catch (Exception e)
			{
				throw e;
			}
		}

		public static async Task<bool> InitLogic(string url)
		{
			_ = 1;
			try
			{
				Logger.LogToFile("[LOGIC START]", ConsoleColor.Cyan, "");
				LoadWeb(url, BrowserLoaded, reset: true);
				await Task.FromResult(ActiveFrames > 0);
				await Task.FromResult(ActiveFrames == 0);
				Logger.LogToFile("[LOGIC END]", ConsoleColor.Cyan, "");
				return true;
			}
			catch (Exception)
			{
				return false;
			}
		}
	}
}
